* Title: 	figure9.do
* Version: 	23 May 2018
* Purpose: 	Produce map of prime male joblessness, 2015


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure9, text replace
set more off
clear all
macro drop _all

* Install maptile geography
maptile_install using dta/maptile_conspuma0010.zip, replace


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip cpuma0010 PrimeMaleD UnempB perwt ///
	using dta/acs_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 2014-2016 ACS
keep if year>=2014 & year<=2016

* Pool 2014-2016 ACS
replace year = 2015 if year>=2014 & year<=2016


*******************************************************************************
* (2) Construct joblessness rates by PUMA
*******************************************************************************

rename cpuma0010 conspuma0010

collapse (sum) Total = PrimeMaleD Jobless = UnempB ///
		 [pw=perwt], by(statefip conspuma0010)

gen Jobless_Rate_2015 = 100 * (Jobless/Total)

keep statefip conspuma0010 Jobless_Rate_2015

* Save dataset
compress
save output/figures/dta/figure9.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

maptile	Jobless_Rate_2015, geo(conspuma0010) conus ///
		cutvalues(10(4)26) ///
		twopt  (legend(title("Not Working Rate, percent", size(vsmall)) ///
		lab(2 "< 10")  ///
		lab(3 "10 - 14")  ///
		lab(4 "14 - 18")  ///
		lab(5 "18 - 22")  ///
		lab(6 "22 - 26")  ///
		lab(7 "> 26")))

graph save output/figures/gph/figure9, replace
graph export output/figures/eps/figure9.eps, as(eps) replace
export excel using output/figures/xlsx/figure9.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
